<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanExpiringSoon extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase,
        public int $daysRemaining
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;
        $coach = $plan->coach;

        return (new MailMessage)
            ->subject('Tu plan expira pronto - ' . $plan->name)
            ->greeting('¡Hola ' . $this->purchase->buyer_name . '!')
            ->line('Tu acceso al plan **' . $plan->name . '** expira en **' . $this->daysRemaining . ' días**.')
            ->line('**Fecha de expiración:** ' . $this->purchase->ends_at->format('d/m/Y'))
            ->line('Para continuar tu progreso y no perder tu acceso, te recomendamos renovar tu plan.')
            ->action('Renovar mi plan', route('public.coach-plan', $plan->slug))
            ->line('¡No pierdas tu racha de progreso! Renueva ahora y sigue transformándote.');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_expiring',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'days_remaining' => $this->daysRemaining,
            'expires_at' => $this->purchase->ends_at->toISOString(),
            'message' => 'Tu plan ' . $this->purchase->coachPlan->name . ' expira en ' . $this->daysRemaining . ' días.',
        ];
    }
}
