<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanPurchasePending extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;
        $coach = $plan->coach;

        return (new MailMessage)
            ->subject('Compra pendiente de verificación - ' . $plan->name)
            ->greeting('¡Hola ' . $this->purchase->buyer_name . '!')
            ->line('Hemos recibido tu solicitud de compra. Tu pago está pendiente de verificación.')
            ->line('**Plan:** ' . $plan->name)
            ->line('**Coach:** ' . $coach->name)
            ->line('**Monto:** $' . number_format($this->purchase->amount, 2))
            ->line('El coach verificará tu pago y activará tu acceso lo antes posible.')
            ->line('Si has realizado una transferencia bancaria, asegúrate de subir el comprobante de pago.')
            ->action('Ver estado de mi compra', url('/client/dashboard'))
            ->line('Te notificaremos cuando tu acceso esté activo.');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_pending',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'amount' => $this->purchase->amount,
            'message' => 'Tu compra del plan ' . $this->purchase->coachPlan->name . ' está pendiente de verificación.',
        ];
    }
}
