<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanPurchaseReactivated extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $siteName = Setting::get('site_name', 'CoachPro');
        $planName = $this->purchase->coachPlan->name ?? 'el plan';
        $coachName = $this->purchase->coachPlan->coach->name ?? 'tu coach';

        return (new MailMessage)
            ->subject("Acceso Reactivado - {$planName}")
            ->greeting("¡Hola {$notifiable->name}!")
            ->line("¡Buenas noticias! Tu acceso al plan **{$planName}** de **{$coachName}** ha sido reactivado.")
            ->line("Ya puedes acceder nuevamente a todo el contenido del plan.")
            ->action('Ver Mi Plan', url('/'))
            ->salutation("Saludos,\nEl equipo de {$siteName}");
    }

    public function toArray(object $notifiable): array
    {
        $planName = $this->purchase->coachPlan->name ?? 'el plan';

        return [
            'type' => 'coach_plan_purchase_reactivated',
            'purchase_id' => $this->purchase->id,
            'plan_name' => $planName,
            'message' => "✅ Tu acceso al plan {$planName} ha sido reactivado",
            'title' => 'Acceso reactivado',
        ];
    }
}
