<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanPurchaseRefunded extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $siteName = Setting::get('site_name', 'CoachPro');
        $planName = $this->purchase->coachPlan->name ?? 'el plan';
        $coachName = $this->purchase->coachPlan->coach->name ?? 'tu coach';
        $currency = Setting::get('currency', 'DOP');
        $amount = number_format($this->purchase->amount_paid ?? 0, 2);

        return (new MailMessage)
            ->subject("Reembolso Procesado - {$planName}")
            ->greeting("Hola {$notifiable->name},")
            ->line("Tu compra del plan **{$planName}** de **{$coachName}** ha sido reembolsada.")
            ->line("**Monto:** \${$amount} {$currency}")
            ->line("El reembolso será procesado según el método de pago original.")
            ->salutation("Saludos,\nEl equipo de {$siteName}");
    }

    public function toArray(object $notifiable): array
    {
        $planName = $this->purchase->coachPlan->name ?? 'el plan';

        return [
            'type' => 'coach_plan_purchase_refunded',
            'purchase_id' => $this->purchase->id,
            'plan_name' => $planName,
            'message' => "💰 Reembolso procesado para el plan {$planName}",
            'title' => 'Reembolso procesado',
        ];
    }
}
