<?php

namespace App\Providers;

use App\Listeners\HandleFailedNotification;
use Carbon\Carbon;
use Illuminate\Notifications\Events\NotificationFailed;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Vite;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Vite::prefetch(concurrency: 3);

        // Configure Carbon locale for Spanish
        Carbon::setLocale('es');

        // Listen for failed notifications and log them
        Event::listen(NotificationFailed::class, HandleFailedNotification::class);
    }
}
