<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('exercise_library', function (Blueprint $table) {
            $table->string('gif_url')->nullable()->after('video_url');
            $table->string('image_url')->nullable()->after('gif_url');
            $table->json('secondary_muscles')->nullable()->after('muscle_group');
            $table->enum('difficulty', ['principiante', 'intermedio', 'avanzado'])->default('intermedio')->after('secondary_muscles');
            $table->boolean('is_compound')->default(false)->after('difficulty');
            $table->boolean('is_system')->default(false)->after('is_active');
            
            $table->index('difficulty');
            $table->index('is_system');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('exercise_library', function (Blueprint $table) {
            $table->dropColumn(['gif_url', 'image_url', 'secondary_muscles', 'difficulty', 'is_compound', 'is_system']);
        });
    }
};
