<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Makes workouts table support templates (no client) and nullable duration
     */
    public function up(): void
    {
        Schema::table('workouts', function (Blueprint $table) {
            // Drop the foreign key constraint first
            $table->dropForeign(['client_id']);
        });
        
        Schema::table('workouts', function (Blueprint $table) {
            // Make client_id nullable for templates
            $table->unsignedBigInteger('client_id')->nullable()->change();
            
            // Re-add the foreign key constraint (now nullable)
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
            
            // Make duration_weeks nullable
            $table->integer('duration_weeks')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('workouts', function (Blueprint $table) {
            $table->dropForeign(['client_id']);
        });
        
        Schema::table('workouts', function (Blueprint $table) {
            $table->unsignedBigInteger('client_id')->nullable(false)->change();
            $table->foreign('client_id')->references('id')->on('clients')->onDelete('cascade');
            $table->integer('duration_weeks')->default(4)->change();
        });
    }
};
