<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_gateway_fees', function (Blueprint $table) {
            $table->id();
            $table->string('gateway'); // stripe, paypal
            $table->decimal('percentage_fee', 5, 3)->default(0); // e.g., 2.9 for 2.9%
            $table->decimal('fixed_fee', 8, 2)->default(0); // e.g., 0.30 for $0.30
            $table->string('currency', 3)->default('USD');
            $table->string('country_code', 2)->nullable(); // For country-specific fees
            $table->boolean('is_active')->default(true);
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->unique(['gateway', 'currency', 'country_code']);
        });
        
        // Insert default fees
        DB::table('payment_gateway_fees')->insert([
            // Stripe US standard fees
            [
                'gateway' => 'stripe',
                'percentage_fee' => 2.9,
                'fixed_fee' => 0.30,
                'currency' => 'USD',
                'country_code' => null,
                'is_active' => true,
                'notes' => 'Stripe standard rate for US cards',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // PayPal standard fees
            [
                'gateway' => 'paypal',
                'percentage_fee' => 3.49,
                'fixed_fee' => 0.49,
                'currency' => 'USD',
                'country_code' => null,
                'is_active' => true,
                'notes' => 'PayPal standard rate for US transactions',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            // Bank transfer (no fees)
            [
                'gateway' => 'bank_transfer',
                'percentage_fee' => 0,
                'fixed_fee' => 0,
                'currency' => 'USD',
                'country_code' => null,
                'is_active' => true,
                'notes' => 'No processing fees for bank transfers',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_gateway_fees');
    }
};
