<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            // Recurring payment fields
            $table->boolean('auto_renew')->default(false)->after('status');
            $table->enum('billing_cycle', ['monthly', 'quarterly', 'yearly', 'once'])->default('once')->after('auto_renew');
            $table->string('payment_gateway', 50)->nullable()->after('billing_cycle'); // paypal, stripe
            $table->string('gateway_subscription_id')->nullable()->after('payment_gateway'); // PayPal/Stripe subscription ID
            $table->string('gateway_plan_id')->nullable()->after('gateway_subscription_id'); // Gateway plan ID
            $table->timestamp('next_billing_date')->nullable()->after('gateway_plan_id');
            $table->timestamp('last_payment_date')->nullable()->after('next_billing_date');
            $table->integer('failed_payment_attempts')->default(0)->after('last_payment_date');
            $table->timestamp('cancelled_at')->nullable()->after('failed_payment_attempts');
            $table->string('cancellation_reason')->nullable()->after('cancelled_at');
            
            // Indexes
            $table->index('auto_renew');
            $table->index('next_billing_date');
            $table->index(['payment_gateway', 'gateway_subscription_id']);
        });

        // Add billing cycle pricing to plans
        Schema::table('plans', function (Blueprint $table) {
            $table->decimal('monthly_price', 10, 2)->nullable()->after('price');
            $table->decimal('quarterly_price', 10, 2)->nullable()->after('monthly_price');
            $table->decimal('yearly_price', 10, 2)->nullable()->after('quarterly_price');
            $table->string('paypal_plan_id')->nullable()->after('yearly_price');
            $table->string('stripe_price_id')->nullable()->after('paypal_plan_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropIndex(['auto_renew']);
            $table->dropIndex(['next_billing_date']);
            $table->dropIndex(['payment_gateway', 'gateway_subscription_id']);
            
            $table->dropColumn([
                'auto_renew',
                'billing_cycle',
                'payment_gateway',
                'gateway_subscription_id',
                'gateway_plan_id',
                'next_billing_date',
                'last_payment_date',
                'failed_payment_attempts',
                'cancelled_at',
                'cancellation_reason',
            ]);
        });

        Schema::table('plans', function (Blueprint $table) {
            $table->dropColumn([
                'monthly_price',
                'quarterly_price',
                'yearly_price',
                'paypal_plan_id',
                'stripe_price_id',
            ]);
        });
    }
};
