<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('photo_likes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('progress_photo_id')->constrained('progress_photos')->onDelete('cascade');
            $table->string('ip_address', 45);
            $table->timestamp('created_at');
            
            $table->unique(['progress_photo_id', 'ip_address']);
            $table->index('progress_photo_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('photo_likes');
    }
};
