<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->decimal('payment_fee', 10, 2)->default(0)->after('discount');
            $table->string('payment_fee_method')->nullable()->after('payment_fee');
            $table->decimal('payment_fee_rate', 5, 2)->nullable()->after('payment_fee_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn(['payment_fee', 'payment_fee_method', 'payment_fee_rate']);
        });
    }
};
