<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Fix status ENUM: change from enum to varchar to support suspended/expired
        DB::statement("ALTER TABLE coach_plan_purchases MODIFY COLUMN status VARCHAR(20) DEFAULT 'pending'");

        // Add SEO fields to coach_plans
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->string('seo_title', 255)->nullable()->after('slug');
            $table->text('seo_description')->nullable()->after('seo_title');
            $table->string('seo_keywords', 500)->nullable()->after('seo_description');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('coach_plans', function (Blueprint $table) {
            $table->dropColumn(['seo_title', 'seo_description', 'seo_keywords']);
        });

        DB::statement("ALTER TABLE coach_plan_purchases MODIFY COLUMN status ENUM('pending', 'paid', 'cancelled', 'refunded') DEFAULT 'pending'");
    }
};
