<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('coach_payment_methods', function (Blueprint $table) {
            $table->string('paypal_me_link')->nullable()->after('paypal_email');
            $table->string('bank_logo')->nullable()->after('bank_name');
        });
    }

    public function down(): void
    {
        Schema::table('coach_payment_methods', function (Blueprint $table) {
            $table->dropColumn(['paypal_me_link', 'bank_logo']);
        });
    }
};
