<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('workouts', function (Blueprint $table) {
            $table->boolean('is_official')->default(false)->after('is_active');
        });

        Schema::table('meal_plans', function (Blueprint $table) {
            $table->boolean('is_official')->default(false)->after('is_active');
        });
    }

    public function down(): void
    {
        Schema::table('workouts', function (Blueprint $table) {
            $table->dropColumn('is_official');
        });

        Schema::table('meal_plans', function (Blueprint $table) {
            $table->dropColumn('is_official');
        });
    }
};
