<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('landing_testimonials', function (Blueprint $table) {
            $table->foreignId('coach_id')->nullable()->after('id')->constrained('users')->onDelete('set null');
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('approved')->after('is_active');
            $table->enum('source', ['admin', 'coach'])->default('admin')->after('status');
            $table->text('rejection_reason')->nullable()->after('source');
            $table->timestamp('submitted_at')->nullable()->after('rejection_reason');
            $table->timestamp('reviewed_at')->nullable()->after('submitted_at');
            $table->foreignId('reviewed_by')->nullable()->after('reviewed_at')->constrained('users')->onDelete('set null');
            
            $table->index(['status', 'is_active']);
            $table->index('coach_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('landing_testimonials', function (Blueprint $table) {
            $table->dropForeign(['coach_id']);
            $table->dropForeign(['reviewed_by']);
            $table->dropIndex(['status', 'is_active']);
            $table->dropIndex(['coach_id']);
            $table->dropColumn([
                'coach_id',
                'status',
                'source',
                'rejection_reason',
                'submitted_at',
                'reviewed_at',
                'reviewed_by',
            ]);
        });
    }
};
