<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Database\Seeder;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Trial',
                'slug' => 'trial',
                'price' => 0,
                'duration_days' => 7,
                'is_active' => true,
                'description' => 'Prueba gratuita de 7 días con funcionalidades limitadas.',
                'features' => [
                    'max_clients' => 1,
                    'max_diets' => 1,
                    'max_routines' => 1,
                    'custom_foods' => false,
                    'pdf_export' => true,
                    'analytics' => 'basic',
                    'support' => 'none',
                ],
            ],
            [
                'name' => 'Básico',
                'slug' => 'basico',
                'price' => 40.00,
                'duration_days' => 30,
                'is_active' => true,
                'description' => 'Plan ideal para coaches que están comenzando.',
                'features' => [
                    'max_clients' => 20,
                    'max_diets' => 20,
                    'max_routines' => 20,
                    'custom_foods' => false,
                    'pdf_export' => true,
                    'analytics' => 'basic',
                    'support' => 'email',
                ],
            ],
            [
                'name' => 'Premium',
                'slug' => 'premium',
                'price' => 95.00,
                'duration_days' => 30,
                'is_active' => true,
                'description' => 'Plan completo para coaches profesionales.',
                'features' => [
                    'max_clients' => -1, // unlimited
                    'max_diets' => -1,
                    'max_routines' => -1,
                    'custom_foods' => true,
                    'pdf_export' => true,
                    'analytics' => 'advanced',
                    'support' => 'priority',
                ],
            ],
        ];

        foreach ($plans as $plan) {
            Plan::updateOrCreate(
                ['slug' => $plan['slug']],
                $plan
            );
        }
    }
}
