@extends('pdf.base')

@section('title', 'Estado de Cuenta - ' . $user->name)

@section('styles')
<style>
    .balance-box {
        background: linear-gradient(135deg, #3b82f6, #1d4ed8);
        color: white;
        padding: 20px;
        border-radius: 12px;
        text-align: center;
    }
    .balance-amount {
        font-size: 32px;
        font-weight: 700;
    }
    .balance-label {
        font-size: 11px;
        opacity: 0.9;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .transaction-in { color: #10b981; }
    .transaction-out { color: #ef4444; }
</style>
@endsection

@section('content')
    <!-- Header -->
    <div class="pdf-header pdf-header-primary">
        <div class="logo">💰 {{ $settings['header'] ?? 'CoachPro' }}</div>
        <h1>Estado de Cuenta</h1>
        <p>{{ $user->name }} · Generado el {{ now()->format('d/m/Y') }}</p>
    </div>

    <!-- Account Summary -->
    <div class="row mb-4">
        <div class="col-6">
            <div class="card">
                <div class="card-header bg-light">
                    <span class="text-primary">👤</span> Información de la Cuenta
                </div>
                <div class="card-body">
                    <table style="border: none;">
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Nombre:</td>
                            <td style="border: none; padding: 5px 0; font-weight: 600;">{{ $user->name }}</td>
                        </tr>
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Email:</td>
                            <td style="border: none; padding: 5px 0;">{{ $user->email }}</td>
                        </tr>
                        @if($user->phone)
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Teléfono:</td>
                            <td style="border: none; padding: 5px 0;">{{ $user->phone }}</td>
                        </tr>
                        @endif
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Cuenta desde:</td>
                            <td style="border: none; padding: 5px 0;">{{ $user->created_at->format('d/m/Y') }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-6">
            <div class="balance-box">
                <div class="balance-label">Saldo Disponible</div>
                <div class="balance-amount">${{ number_format($wallet->balance ?? 0, 2) }}</div>
                <div style="font-size: 10px; margin-top: 5px; opacity: 0.8;">{{ $currency ?? 'USD' }}</div>
            </div>
        </div>
    </div>

    <!-- Period Summary -->
    @if(isset($summary))
    <div class="stats-grid mb-4">
        <div class="stat-box">
            <span class="stat-value transaction-in">${{ number_format($summary['total_in'] ?? 0, 2) }}</span>
            <span class="stat-label">Total Ingresos</span>
        </div>
        <div class="stat-box">
            <span class="stat-value transaction-out">${{ number_format($summary['total_out'] ?? 0, 2) }}</span>
            <span class="stat-label">Total Egresos</span>
        </div>
        <div class="stat-box">
            <span class="stat-value" style="color: #8b5cf6;">{{ $summary['total_transactions'] ?? 0 }}</span>
            <span class="stat-label">Transacciones</span>
        </div>
    </div>
    @endif

    <!-- Transactions -->
    @if(isset($transactions) && count($transactions) > 0)
    <div class="section">
        <div class="section-title">
            <span class="text-primary">📋</span> Historial de Transacciones
            @if(isset($period))
            <span style="font-weight: normal; font-size: 11px; color: #6b7280;"> · {{ $period }}</span>
            @endif
        </div>
        <table class="table-striped">
            <thead>
                <tr style="background-color: #3b82f6; color: white;">
                    <th style="width: 15%;">Fecha</th>
                    <th style="width: 40%;">Descripción</th>
                    <th style="width: 15%;">Tipo</th>
                    <th style="width: 15%; text-align: right;">Monto</th>
                    <th style="width: 15%; text-align: right;">Saldo</th>
                </tr>
            </thead>
            <tbody>
                @foreach($transactions as $transaction)
                <tr>
                    <td>{{ $transaction->created_at->format('d/m/Y') }}</td>
                    <td>{{ $transaction->description }}</td>
                    <td>
                        <span class="badge {{ $transaction->type === 'credit' ? 'badge-success' : 'badge-danger' }}">
                            {{ $transaction->type === 'credit' ? 'Ingreso' : 'Egreso' }}
                        </span>
                    </td>
                    <td style="text-align: right; font-weight: 600;" class="{{ $transaction->type === 'credit' ? 'transaction-in' : 'transaction-out' }}">
                        {{ $transaction->type === 'credit' ? '+' : '-' }}${{ number_format($transaction->amount, 2) }}
                    </td>
                    <td style="text-align: right;">${{ number_format($transaction->balance_after ?? 0, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @else
    <div class="info-box">
        <p style="text-align: center; margin: 0;">No hay transacciones registradas en este período.</p>
    </div>
    @endif

    <!-- Invoices Summary -->
    @if(isset($invoices) && count($invoices) > 0)
    <div class="section">
        <div class="section-title">
            <span class="text-primary">📄</span> Facturas del Período
        </div>
        <table class="table-bordered">
            <thead>
                <tr style="background-color: #f3f4f6;">
                    <th>Número</th>
                    <th>Fecha</th>
                    <th>Concepto</th>
                    <th style="text-align: center;">Estado</th>
                    <th style="text-align: right;">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoices as $invoice)
                <tr>
                    <td style="font-weight: 600;">{{ $invoice->invoice_number }}</td>
                    <td>{{ $invoice->created_at->format('d/m/Y') }}</td>
                    <td>{{ $invoice->subscription?->plan?->name ?? 'Servicio' }}</td>
                    <td style="text-align: center;">
                        <span class="badge {{ $invoice->status === 'paid' ? 'badge-success' : ($invoice->status === 'pending' ? 'badge-warning' : 'badge-danger') }}">
                            {{ $invoice->status === 'paid' ? 'Pagada' : ($invoice->status === 'pending' ? 'Pendiente' : 'Cancelada') }}
                        </span>
                    </td>
                    <td style="text-align: right; font-weight: 600;">${{ number_format($invoice->total, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <!-- Footer -->
    <div class="pdf-footer">
        <div class="logo text-primary">{{ $settings['header'] ?? 'CoachPro' }}</div>
        <p>Este documento es un resumen informativo de su estado de cuenta.</p>
        @if($settings['footer'] ?? null)
        <p>{{ $settings['footer'] }}</p>
        @endif
    </div>
@endsection
