<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Factura {{ $invoice->invoice_number }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700\u0026display=swap');
        
        * {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }
        
        @page {
            size: A4;
            margin: 0;
        }
        
        body {
            -webkit-print-color-adjust: exact !important;
            print-color-adjust: exact !important;
        }
    </style>
</head>
<body class="bg-white min-h-screen">
    <!-- Header (Logo Only) -->
    <div class="px-8 py-6 border-b border-gray-200">
        <div class="flex items-start justify-between">
            <div>
                @if(isset($settings['logo']) && $settings['logo'])
                    <img src="{{ asset('storage/' . $settings['logo']) }}" alt="Logo" class="h-14">
                @endif
            </div>
            <div class="text-right">
                <!-- Status Badge (Solid Colors, No Gradients) -->
                @if($invoice->status === 'paid')
                    <span class="inline-flex items-center px-4 py-2 rounded-lg text-sm font-bold bg-green-100 text-green-700 border border-green-200">
                        ✓ PAGADA
                    </span>
                @elseif($invoice->status === 'pending')
                    <span class="inline-flex items-center px-4 py-2 rounded-lg text-sm font-bold bg-amber-100 text-amber-700 border border-amber-200">
                        ⏳ PENDIENTE
                    </span>
                @else
                    <span class="inline-flex items-center px-4 py-2 rounded-lg text-sm font-bold bg-red-100 text-red-700 border border-red-200">
                        ✕ CANCELADA
                    </span>
                @endif
            </div>
        </div>
    </div>

    <div class="px-8 py-8">
        <!-- Info Cards -->
        <div class="grid grid-cols-2 gap-6 mb-8">
            <!-- Client Info -->
            <div class="border border-gray-200 rounded-lg p-6">
                <div class="flex items-center gap-2 mb-4 pb-3 border-b border-gray-100">
                    <span class="text-xl">👤</span>
                    <h3 class="font-semibold text-gray-700">Datos del Cliente</h3>
                </div>
                <div class="space-y-2">
                    <p class="text-lg font-bold text-gray-900">{{ $invoice->user->name }}</p>
                    <p class="text-gray-600 flex items-center gap-2">
                        <span class="text-gray-400">✉️</span> {{ $invoice->user->email }}
                    </p>
                    @if($invoice->user->phone)
                        <p class="text-gray-600 flex items-center gap-2">
                            <span class="text-gray-400">📱</span> {{ $invoice->user->phone }}
                        </p>
                    @endif
                </div>
            </div>

            <!-- Invoice Info (Now includes Invoice Number) -->
            <div class="border border-gray-200 rounded-lg p-6">
                <div class="flex items-center gap-2 mb-4 pb-3 border-b border-gray-100">
                    <span class="text-xl">📋</span>
                    <h3 class="font-semibold text-gray-700">Información de Factura</h3>
                </div>
                <div class="space-y-3">
                    <div class="flex justify-between">
                        <span class="text-gray-500">N° Factura:</span>
                        <span class="font-bold text-gray-900">{{ $invoice->invoice_number }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-500">Fecha emisión:</span>
                        <span class="font-semibold text-gray-900">{{ $invoice->created_at->format('d/m/Y') }}</span>
                    </div>
                    @if($invoice->paid_at)
                        <div class="flex justify-between">
                            <span class="text-gray-500">Fecha pago:</span>
                            <span class="font-semibold text-green-600">{{ $invoice->paid_at->format('d/m/Y') }}</span>
                        </div>
                    @endif
                    @if($invoice->payment_method)
                        <div class="flex justify-between">
                            <span class="text-gray-500">Método:</span>
                            <span class="font-semibold text-gray-900">
                                @if($invoice->payment_method === 'stripe')
                                    💳 Tarjeta (Stripe)
                                @elseif($invoice->payment_method === 'paypal')
                                    🅿️ PayPal
                                @else
                                    🏦 Transferencia
                                @endif
                            </span>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Items Table (Minimalist, No Gradients) -->
        <div class="border border-gray-200 rounded-lg overflow-hidden mb-8">
            <div class="bg-gray-50 px-6 py-4 border-b border-gray-200">
                <h3 class="text-gray-700 font-semibold flex items-center gap-2">
                    <span>📦</span> Detalle de Factura
                </h3>
            </div>
            <table class="w-full">
                <thead>
                    <tr class="bg-gray-50 border-b border-gray-200">
                        <th class="text-left px-6 py-3 font-semibold text-gray-600 text-sm uppercase tracking-wider">Descripción</th>
                        <th class="text-center px-4 py-3 font-semibold text-gray-600 text-sm uppercase tracking-wider">Cant.</th>
                        <th class="text-right px-4 py-3 font-semibold text-gray-600 text-sm uppercase tracking-wider">Precio Unit.</th>
                        <th class="text-right px-6 py-3 font-semibold text-gray-600 text-sm uppercase tracking-wider">Total</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($items as $item)
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4">
                                <p class="font-medium text-gray-900">{{ $item['description'] }}</p>
                            </td>
                            <td class="px-4 py-4 text-center">
                                <span class="inline-flex items-center px-3 py-1 rounded-lg text-sm font-medium bg-gray-100 text-gray-700">
                                    {{ $item['quantity'] }}
                                </span>
                            </td>
                            <td class="px-4 py-4 text-right text-gray-600">
                                ${{ number_format($item['unit_price'], 2) }}
                            </td>
                            <td class="px-6 py-4 text-right font-bold text-gray-900">
                                ${{ number_format($item['total'], 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Totals & Notes -->
        <div class="grid grid-cols-2 gap-6">
            <!-- Notes -->
            <div>
                @if($invoice->notes || !empty($settings['footer_text']))
                    <div class="border border-gray-200 rounded-lg p-5">
                        <h4 class="font-semibold text-gray-700 mb-3 flex items-center gap-2">
                            <span>📝</span> Notas
                        </h4>
                        @if($invoice->notes)
                            <p class="text-gray-600 text-sm">{{ $invoice->notes }}</p>
                        @endif
                        @if(!empty($settings['footer_text']))
                            <p class="text-gray-500 text-sm mt-2 italic">{{ $settings['footer_text'] }}</p>
                        @endif
                    </div>
                @endif
            </div>

            <!-- Totals (Clean, No Gradients) -->
            <div class="border border-gray-200 rounded-lg overflow-hidden">
                <div class="divide-y divide-gray-200">
                    <div class="flex justify-between px-6 py-4 bg-gray-50">
                        <span class="text-gray-600">Subtotal</span>
                        <span class="font-semibold text-gray-900">${{ number_format($invoice->subtotal, 2) }}</span>
                    </div>
                    @if($invoice->taxes_applied && is_array($invoice->taxes_applied) && count($invoice->taxes_applied) > 0)
                        @foreach($invoice->taxes_applied as $tax)
                            <div class="flex justify-between px-6 py-3 bg-white">
                                <span class="text-gray-500">{{ $tax['name'] }}{{ isset($tax['rate']) ? ' (' . $tax['rate'] . '%)' : '' }}</span>
                                <span class="text-gray-700">${{ number_format($tax['amount'], 2) }}</span>
                            </div>
                        @endforeach
                    @elseif($invoice->tax > 0)
                        <div class="flex justify-between px-6 py-3 bg-white">
                            <span class="text-gray-500">Impuestos</span>
                            <span class="text-gray-700">${{ number_format($invoice->tax, 2) }}</span>
                        </div>
                    @endif
                    <div class="flex justify-between px-6 py-5 bg-gray-900 text-white">
                        <span class="text-lg font-bold">TOTAL</span>
                        <span class="text-2xl font-bold">${{ number_format($invoice->total, 2) }}</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transaction ID -->
        @if($invoice->transaction_id)
            <div class="mt-6 text-center">
                <p class="text-xs text-gray-400">
                    ID de Transacción: <span class="font-mono">{{ $invoice->transaction_id }}</span>
                </p>
            </div>
        @endif
    </div>

    <!-- Footer -->
    <div class="fixed bottom-0 left-0 right-0 bg-gray-50 px-8 py-4 border-t border-gray-200">
        <div class="flex items-center justify-between">
            <div>
                <p class="font-bold text-gray-800">{{ $settings['site_name'] ?? 'CoachPro' }}</p>
                <p class="text-xs text-gray-500">Gracias por su confianza</p>
            </div>
            <div class="text-right text-xs text-gray-500">
                <p>Documento generado el {{ now()->format('d/m/Y H:i') }}</p>
            </div>
        </div>
    </div>
</body>
</html>
