@extends('pdf.base')

@section('title', 'Estadísticas - ' . $client->name)

@section('styles')
<style>
    .progress-img { max-width: 100%; height: auto; border-radius: 8px; }
    .chart-placeholder {
        background: linear-gradient(135deg, #f3f4f6 0%, #e5e7eb 100%);
        height: 120px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #9ca3af;
        font-size: 10px;
    }
    .trend-up { color: #10b981; }
    .trend-down { color: #ef4444; }
    .trend-same { color: #6b7280; }
</style>
@endsection

@section('content')
    <!-- Header -->
    <div class="pdf-header pdf-header-purple">
        <div class="logo">📊 {{ $settings['header'] ?? 'CoachPro' }}</div>
        <h1>Reporte de Progreso</h1>
        <p>{{ $client->name }} · {{ $period ?? 'Histórico completo' }}</p>
    </div>

    <!-- Client Summary -->
    <div class="row mb-4">
        <div class="col-6">
            <div class="card">
                <div class="card-header bg-light">
                    <span style="color: #8b5cf6;">👤</span> Información del Cliente
                </div>
                <div class="card-body">
                    <table style="border: none;">
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Nombre:</td>
                            <td style="border: none; padding: 5px 0; font-weight: 600;">{{ $client->name }}</td>
                        </tr>
                        @if($client->age)
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Edad:</td>
                            <td style="border: none; padding: 5px 0;">{{ $client->age }} años</td>
                        </tr>
                        @endif
                        @if($client->objective)
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Objetivo:</td>
                            <td style="border: none; padding: 5px 0;">
                                <span class="badge badge-primary">{{ ucfirst($client->objective) }}</span>
                            </td>
                        </tr>
                        @endif
                        @if($client->created_at)
                        <tr style="border: none;">
                            <td style="border: none; padding: 5px 15px 5px 0; color: #6b7280;">Inicio:</td>
                            <td style="border: none; padding: 5px 0;">{{ $client->created_at->format('d/m/Y') }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
        </div>
        <div class="col-6">
            <div class="stats-grid">
                <div class="stat-box">
                    <span class="stat-value" style="color: #8b5cf6;">{{ $stats['total_workouts'] ?? 0 }}</span>
                    <span class="stat-label">Entrenamientos</span>
                </div>
                <div class="stat-box">
                    <span class="stat-value" style="color: #10b981;">{{ $stats['total_meal_plans'] ?? 0 }}</span>
                    <span class="stat-label">Dietas</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Weight Progress -->
    @if(isset($measurements) && count($measurements) > 0)
    <div class="section">
        <div class="section-title">
            <span style="color: #8b5cf6;">⚖️</span> Evolución de Peso
        </div>
        <table class="table-striped">
            <thead>
                <tr style="background-color: #8b5cf6; color: white;">
                    <th>Fecha</th>
                    <th style="text-align: center;">Peso (kg)</th>
                    <th style="text-align: center;">Variación</th>
                    <th style="text-align: center;">% Grasa</th>
                    <th style="text-align: center;">% Músculo</th>
                    <th>Notas</th>
                </tr>
            </thead>
            <tbody>
                @foreach($measurements as $index => $measurement)
                @php
                    $prevWeight = $index > 0 ? $measurements[$index - 1]->weight : null;
                    $diff = $prevWeight ? $measurement->weight - $prevWeight : 0;
                @endphp
                <tr>
                    <td>{{ $measurement->date->format('d/m/Y') }}</td>
                    <td style="text-align: center; font-weight: 600;">{{ number_format($measurement->weight, 1) }}</td>
                    <td style="text-align: center;">
                        @if($diff != 0)
                            <span class="{{ $diff > 0 ? 'trend-up' : 'trend-down' }}">
                                {{ $diff > 0 ? '+' : '' }}{{ number_format($diff, 1) }} kg
                            </span>
                        @else
                            <span class="trend-same">-</span>
                        @endif
                    </td>
                    <td style="text-align: center;">{{ $measurement->body_fat ? number_format($measurement->body_fat, 1) . '%' : '-' }}</td>
                    <td style="text-align: center;">{{ $measurement->muscle_mass ? number_format($measurement->muscle_mass, 1) . '%' : '-' }}</td>
                    <td style="font-size: 10px; color: #6b7280;">{{ $measurement->notes ?? '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        @if(count($measurements) >= 2)
        <div class="info-box" style="margin-top: 15px;">
            @php
                $firstWeight = $measurements->first()->weight;
                $lastWeight = $measurements->last()->weight;
                $totalChange = $lastWeight - $firstWeight;
            @endphp
            <strong>📈 Resumen de Progreso:</strong>
            <p style="margin: 10px 0 0 0;">
                Peso inicial: <strong>{{ number_format($firstWeight, 1) }} kg</strong> →
                Peso actual: <strong>{{ number_format($lastWeight, 1) }} kg</strong>
                <span class="badge {{ $totalChange < 0 ? 'badge-success' : ($totalChange > 0 ? 'badge-warning' : 'badge-info') }}" style="margin-left: 10px;">
                    {{ $totalChange > 0 ? '+' : '' }}{{ number_format($totalChange, 1) }} kg
                </span>
            </p>
        </div>
        @endif
    </div>
    @endif

    <!-- Body Measurements -->
    @if(isset($bodyMeasurements) && count($bodyMeasurements) > 0)
    <div class="section">
        <div class="section-title">
            <span style="color: #8b5cf6;">📏</span> Medidas Corporales
        </div>
        <table class="table-bordered">
            <thead>
                <tr style="background-color: #f3f4f6;">
                    <th>Fecha</th>
                    <th style="text-align: center;">Pecho</th>
                    <th style="text-align: center;">Cintura</th>
                    <th style="text-align: center;">Cadera</th>
                    <th style="text-align: center;">Bíceps</th>
                    <th style="text-align: center;">Muslo</th>
                </tr>
            </thead>
            <tbody>
                @foreach($bodyMeasurements as $m)
                <tr>
                    <td>{{ $m->date->format('d/m/Y') }}</td>
                    <td style="text-align: center;">{{ $m->chest ? $m->chest . ' cm' : '-' }}</td>
                    <td style="text-align: center;">{{ $m->waist ? $m->waist . ' cm' : '-' }}</td>
                    <td style="text-align: center;">{{ $m->hips ? $m->hips . ' cm' : '-' }}</td>
                    <td style="text-align: center;">{{ $m->biceps ? $m->biceps . ' cm' : '-' }}</td>
                    <td style="text-align: center;">{{ $m->thigh ? $m->thigh . ' cm' : '-' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <!-- Progress Photos -->
    @if(isset($photos) && count($photos) > 0)
    <div class="section">
        <div class="section-title">
            <span style="color: #8b5cf6;">📸</span> Fotos de Progreso
        </div>
        <div class="row">
            @foreach($photos->take(4) as $photo)
            <div class="col-3 text-center" style="padding: 5px;">
                @if(file_exists(public_path('storage/' . $photo->photo_path)))
                <img src="{{ public_path('storage/' . $photo->photo_path) }}" class="progress-img" style="max-height: 150px;">
                @else
                <div class="chart-placeholder" style="height: 100px;">
                    <span>Imagen no disponible</span>
                </div>
                @endif
                <div style="font-size: 9px; color: #6b7280; margin-top: 5px;">
                    {{ $photo->taken_at->format('d/m/Y') }}
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif

    <!-- Summary Notes -->
    @if(isset($notes) && $notes)
    <div class="info-box">
        <strong>📝 Observaciones del Entrenador:</strong>
        <p style="margin-top: 10px;">{{ $notes }}</p>
    </div>
    @endif

    <!-- Footer -->
    <div class="pdf-footer">
        <div class="logo" style="color: #8b5cf6;">{{ $settings['header'] ?? 'CoachPro' }}</div>
        <p>Reporte generado automáticamente · ¡Sigue así! 💪</p>
        @if($settings['footer'] ?? null)
        <p>{{ $settings['footer'] }}</p>
        @endif
    </div>
@endsection
